;; this is meant to be a drop-in replacement for cnf.lisp, using
;; NiceSAT for CNF;; generation

(defvar *nicesat-vars* nil)
(defvar *nicesat* nil)

(defvar *nicesat-file* nil)

(defun list-to-vec (l)
  (let ((v (new_EdgeVec)))
    (loop for e in l do (EdgeVec_push v e))
    v))

(defun ns-neg (e)
  (let ((e (new_Edge e)))
    (Edge_negate e)
    e))

(defun ns-and (ns l)
  (let ((v (list-to-vec l)))
    (NiceSat_createAnd_Vec ns v)))

(defun ns-or (ns l)
  (let ((v (list-to-vec l)))
    (NiceSat_createOr_Vec ns v)))

(defun ns-ite (ns tst tt ff)
  (NiceSat_createIte ns tst tt ff))

(defun ns-iff (ns ant cns)
  (NiceSat_createIff ns ant cns))

(defun ns-gen-vars (ns l)
  (let ((h (make-hash-table)))
    (loop
       for f in l do
         (setf (gethash (formula-value f) h)
               (NiceSat_createVar ns)))
    h))

(defun dag-to-nsdag (ns form vhash)
  (if (formula-slot1 form)
      (formula-slot1 form)
      (setf (formula-slot1 form)
            (flet ((dtns (f) (dag-to-nsdag ns f vhash)))
              (case (formula-fn form)
                (var (setf (formula-slot2 form)
                           (gethash (formula-value form) vhash)))
                (not (ns-neg (dtns (first (formula-args form)))))
                (and (ns-and ns (mapcar #'dtns (formula-args form))))
                (or (ns-or ns (mapcar #'dtns (formula-args form))))
                (if (let* ((args (formula-args form))
                           (tst-nsdag (dtns (first args)))
                           (tt-nsdag (dtns (second args)))
                           (ff-nsdag (dtns (third args))))
                      (ns-ite ns tst-nsdag tt-nsdag ff-nsdag)))
                (<-> (let* ((args (formula-args form))
                            (ant-nsdag (dtns (first args)))
                            (con-nsdag (dtns (second args))))
                       (ns-iff ns ant-nsdag con-nsdag)))
                (otherwise (break (format
                                   nil
                                   "dag-to-nsdag: unexpected function: ~A"
                                   (formula-fn form)))))))))

;; copied from cnf.lisp
(defun sortvars (vars ovars)
  (let ((vhash (make-hash-table :test 'eq :size (length vars)))
	(n 0))
    (dolist (ovar ovars)
      (let ((name (first ovar)))
	(setf (gethash name vhash) (incf n))))
    (dolist (var vars)
      (let* ((name (first (formula-args var)))
	     (val  (gethash name vhash)))
	(unless val (setf (gethash name vhash) (incf n)))))
    (sort vars
	  (lambda (v1 v2)
	    (let* ((args1 (formula-args v1))
		   (name1 (gethash (first args1) vhash))
		   (step1 (second args1))
		   (bit1  (third args1))
		   (args2 (formula-args v2))
		   (name2 (gethash (first args2) vhash))
		   (step2 (second args2))
		   (bit2  (third args2)))
	      (or (< step1 step2)
		  (and (= step1 step2)
		       (or (< name1 name2)
			   (and (= name1 name2)
				(< bit1 bit2))))))))))

(defun used-vars (vars)
  (let ((count-used 0))
    (loop for var in vars
       when (formula-slot2 var)
       do (incf count-used)
       and collect (cons var count-used) into vlist
       finally (return (let ((varray (make-array (1+ count-used))))
                         (dolist (vpair vlist)
                           (setf (aref varray (cdr vpair))
                                 (car vpair)))
                         (setf *nicesat-vars* varray)
                         (values count-used varray))))))

(defun ns-cnf (form vars)
  (let* ((solver (if *nicesat-file*
                     (let* ((str (new_string *nicesat-file*))
                            (solver (new_FileSolver str))
                            (delete_string str))
                       solver)
                     (new_PicoSatSolver)))
         (ns (new_NiceSat solver))
         (vhash (ns-gen-vars ns vars)))
    (setf *nicesat* ns)
    (NiceSat_add ns (dag-to-nsdag ns form vhash))
    (multiple-value-bind (counter vars) (used-vars vars)
      (values 'dummy vars counter 0 0))))

(defun cnf (form vars ovars)
  (let* ((vars (sortvars vars ovars)))
    (ns-cnf form vars)))

;; dummy function to keep compatibility with cnf.lisp
(defun print-comp-cnf (clauses varray name slv-none vcount ccount lcount)
  nil)

(defun solve (solver filename)
  (when (equal (NiceSat_solve *nicesat*) :Answer_Satisfiable)
    (let* ((nvars (array-dimension *nicesat-vars* 0))
           (vals (make-array nvars
                             :element-type 'boolean
                             :initial-element nil)))
      (loop
         for i from 1 to (- nvars 1) do
           (setf (aref vals i)
                 (equal (NiceSat_Deref *nicesat*
                                       (formula-slot2
                                        (aref *nicesat-vars* i)))
                        :Assignment_True)))
      vals)))

(declaim (ftype (function ((array boolean) array list list fixnum)
                          null) print-results))
(defun print-results (vals varray vdefs mac-alist steps)
  (let* ((sz (length vdefs))
	 (vhash (make-hash-table :size sz))
	 (mems nil))
    (loop for i from 1 below (array-dimension varray 0)
       do (setf (formula-slot1 (aref varray i))
                (if (aref vals i) *one* *zero*))
         #|do (format t "~A = ~A~%" (aref varray i) (aref vals i))|#)
    (dolist (vdef vdefs nil)
      (cond ((eq (second vdef) 'mem)
	     (let ((mem (make-array (1+ steps)
				    :element-type 'list
				    :initial-element nil)))
	       (dotimes (i (1+ steps) (setf mems (acons (first vdef)
                                                        mem mems)))
		 ;; (format t "~&mem: ~A step: ~A" (first vdef) i)
;; Printing out memory information needs to be fixed. The code
;; below is currently broken, ie, it doesn't work with V2 nicedags.
#|		 (let ((val (cdr (assoc (cons (first vdef) i)
                                        mac-alist
                                        :test 'equal))))
		   (when val
		     (let ((m (instantiate (car val)))
			   (ac (cdr val))
			   (nmemi nil))
		       ;;(format t "~%(car val): ~A~% m: ~A~%" (car val) m)
		       (maphash (lambda (a c)
				  (let ((na (instantiate a)))
				    (unless (assoc na nmemi :test 'eq)
				      (setf nmemi
					    (acons na
						   (cnf-simplify-get m c)
						   nmemi)))))
				ac)
		       (setf (aref mem i) nmemi))))|#)))
	    (t
	     (setf (gethash (first vdef) vhash)
		   (make-array (list (1+ steps) (type-bits (cdr vdef))) 
			       :element-type 'bit 
			       :initial-element 0)))))
    (loop for i from 1 to (1- (array-dimension varray 0)) do
         (when (eq (formula-slot1 (aref varray i)) *one*)
           (let* ((sbv (formula-args (aref varray i)))
                  (var (first sbv))
                  (step (second sbv))
                  (bit (third sbv)))
             ;; (format t "var ~A~%" var)
             (multiple-value-bind
                   (a found?)
                 (gethash var vhash)
               (when found?
                 (setf (aref a step bit) 1))))))
    (dotimes (i (1+ steps) nil)
      (unless (= steps 0) (format t "---Step ~A---~%" i))
      (dolist (vdef vdefs nil)
	(if (eq (second vdef) 'mem)
	    (let ((v-alist (aref (cdr (assoc (first vdef) mems
                                             :test 'eq))
                                 i)))
	      ;; (format t "v-alist: ~A~%" v-alist)
	      (dolist (pr v-alist)
		(format t "  ~A word ~A = ~A~%"
			(first vdef)
			(car pr)
			(cdr pr))))
            (let* ((key (car vdef))
                   (val (gethash key vhash)))
              (format t "  ~A = 0b" key)
              (let ((ad (array-dimension val 1)))
                (dotimes (j ad (format t "~%"))
                  (format t "~A" (aref val i (1- (- ad j))))))))))))
